//
//  AirGapDeactivationView.swift
//  DeveloperDemo
//
//  Created by Alkenso (Vladimir Vashurkin) on 12.09.2023.
//

import LicenseSpring

import SwiftUI

struct AirGapDeactivationView: View {
    @State private var initializationCode = ""
    @State private var deactivationCode = ""
    @State private var confirmationCode = ""
    
    let licenseKey: String
    let hardwareID: String
    let generateCode: (String) -> String
    let confirmCode: (String) -> Void
    
    var body: some View {
        Form {
            TextField("License Key", text: .constant(licenseKey))
            TextField("Initialization Code", text: $initializationCode)
            MinWidthButton("Generate Dectivation Code", width: 168) {
                deactivationCode = generateCode(initializationCode)
//                performAction(name: "Air-gap Dectivation", successAlert: false) {
//                    deactivationCode = generateCode(initializationCode)
//                }
            }
            .disabled(initializationCode.isEmpty)
            
            TextField("Deactivation Code", text: .constant(deactivationCode))
                .disabled(deactivationCode.isEmpty)
            TextField("Hardware ID", text: .constant(deactivationCode.isEmpty ? "" : hardwareID))
                .disabled(deactivationCode.isEmpty)
            
            TextField("Confirmation Code", text: $confirmationCode)
                .disabled(deactivationCode.isEmpty)
            MinWidthButton("Dectivate", width: 168) {
                confirmCode(confirmationCode)
//                performAction(name: "Air-gap Dectivation", successAlert: true) {
//                    try license?.deactivateAirGap(confirmationCode: confirmationCode)
//                }
            }
            .disabled(confirmationCode.isEmpty)
        }
    }
}

struct AirGapDeactivationView_Previews: PreviewProvider {
    static var previews: some View {
        AirGapDeactivationView(licenseKey: "key", hardwareID: "hw id", generateCode: { $0 }, confirmCode: { _ in })
    }
}
